const transformHook = (rw) => {    
    // Get values from the context
    const { imageResource = {} } = rw.props

    // Extract image properties
    const { width, height, aspect, format } = imageResource

    // Resize the image to different sizes
    const imagePaths = {
        full: imageResource.path,
        80: rw.resizeResource(imageResource, 80),
        200: rw.resizeResource(imageResource, 200),
        400: rw.resizeResource(imageResource, 400),
        500: rw.resizeResource(imageResource, 500)
    }

    // Set properties in our template data
    rw.setProps({
        hooksData : `<b>Width</b>:${width}, <b>Height</b>:${height}, <b>Aspect</b>:${aspect}, <b>Format</b>:${format} `,
        imagePaths
    })
}

exports.transformHook = transformHook;
